const sendResponse = require("../Helper/Helper");
const EmployeeModel = require("../models/EmployeeModel");
const Shopify = require("shopify-api-node");
const axios = require("axios");
var dotenv = require("dotenv");
const Hash = require("../Helper/hashing");
const StoreSchema = require("../models/StoreSchema");
const OrganizationModel = require("../models/OrganizationModel");
const EmployeeController = require("../Controller/employeeController");
dotenv.config();

const Controller = {
  //add order discount
  AddOrderDiscount: async (req, res) => {
    try {
      const { employeeEmail, employeeAssociation, journey, subTotal } =
        req.body;
      let isUpdateCap = false;
      if (journey) {
        isUpdateCap = true;
      }
      if (!employeeAssociation) {
        return res.status(404).send({
          status: false,
          message: "No employee association key found with data paylaod.",
        });
      }
      if (!employeeAssociation) {
        return res.status(404).send({
          status: false,
          message: "No employee association key found with data paylaod.",
        });
      }
      if (!subTotal) {
        return res.status(404).send({
          status: false,
          message: "No sub total key found with data paylaod.",
        });
      }

      const store = await StoreSchema.findOne({
        shopName: employeeAssociation,
      });

      if (!store) {
        return res.status(404).send({
          status: false,
          message: "No credentials found for the shop.",
        });
      }

      let errArr = [];

      if (!employeeEmail) {
        errArr.push("Required employee email");
      }
      if (errArr.length > 0) {
        res
          .send(sendResponse(false, errArr, null, "Required All Fields"))
          .status(400);
      } else {
        const decryptedApiKey = await Hash.decrypt(store.apiKey);
        const decryptedApiSecret = await Hash.decrypt(store.apiSecret);

        if (!employeeAssociation && !decryptedApiKey && !decryptedApiSecret)
          return res.status(404).send({
            status: false,
            message: "No credentials found i.e decrypted api key or api secret",
          });

        const shopify = new Shopify({
          shopName: employeeAssociation,
          apiKey: decryptedApiKey,
          password: decryptedApiSecret,
        });

        //match fetched employeeEmail with our mongo db employee email
        let userExist = await EmployeeModel.findOne({ email: employeeEmail });

        if (!userExist) {
          let organizationExist = await OrganizationModel.findOne({
            organizationDomain: employeeEmail.split("@")[1].split(".")[0],
          });
          console.log("checking", organizationExist);
          if (organizationExist) {
            const { data, message, status } =
              await EmployeeController.addEmployee(
                {
                  body: {
                    email: employeeEmail,
                    userCapTotal: organizationExist.userCapTotal,
                    employeeAssociation: organizationExist.employeeAssociation,
                    discountType: organizationExist.discountType,
                    discountValue: organizationExist.discountValue,
                    discountFormat: organizationExist.discountFormat,
                    ...(organizationExist.discountFormat !== "Order"
                      ? {
                          CollectionId:
                            organizationExist.discountInfo.collectionIds,
                        }
                      : {}),
                    employeeOrganization: organizationExist._id.toString(),
                  },
                },
                null,
                true
              );
            if (message) {
              console.log(
                "why employee automatically not created?",
                message,
                data,
                status
              );
            }
            if (status) {
              // userExist = null;
              userExist = data;
              userExist.id = userExist._id.toString();
              // userExist = { ...userExist, id: userExist._id.toString() };
            }
          }
        }

        if (userExist) {
          // userExist = Object(userExist);
          console.log(
            "checksum",
            userExist,
            userExist.hasOwnProperty("discountType")
          );
          const value =
            userExist.discountType.toLowerCase() === "percentage"
              ? (parseInt(userExist.discountValue) / 100) *
                parseInt(Math.round(subTotal))
              : parseInt(userExist.discountValue);
          if (!isUpdateCap) {
            // console.log("user", userExist);

            //if emp match found get its grade and find discount % based on grades

            //if user remaining cap is 0 check right now order's date
            //does it ahead of allocated month of an employee
            //if so then re-allocated total cap to remaining cap. otherwise return message
            //your current month quota has been reached.

            const extractMonth =
              new Date(userExist.allocatedMonth).getUTCMonth() + 1;
            const extractCurrentApiCallMonth = new Date().getUTCMonth() + 1;

            if (
              userExist.userCapRemain === 0 &&
              extractMonth === extractCurrentApiCallMonth
            ) {
              res
                .send(
                  sendResponse(
                    false,
                    null,
                    `Your Current Quota for this month (${new Date(
                      userExist.allocatedMonth
                    ).toDateString()}) has been reached ,cap remaining (${
                      userExist.userCapRemain
                    })`
                  )
                )
                .status(404);
              return;
            }

            if (
              userExist.userCapRemain === 0 &&
              extractMonth < extractCurrentApiCallMonth
            ) {
              //update allocation month date as well
              const payload = {
                userCapRemain: userExist.userCapTotal,
                allocatedMonth: Date.now(),
              };

              await EmployeeModel.findByIdAndUpdate(userExist.id, payload, {
                new: true,
              });
            }
            // return;

            //check available employee cap is greater than its grade's correspond percentage.
            // userExist.userCapRemain

            //from total cap i.e 10000 find out how much cap is user wants to be allocated i.e grade 17's => 17%
            // 17% / 100 * 10000 = 1700 /= discount wanted to be allocated.

            if (parseInt(userExist.discountValue) > userExist.userCapRemain) {
              res
                .send(
                  sendResponse(
                    false,
                    null,
                    `Based on user's designated discount value, ${
                      userExist.discountValue
                    }${
                      userExist.discountType.toLowerCase() === "percentage"
                        ? "%"
                        : "$"
                    } discount is greater then available cap of ${
                      userExist.userCapRemain
                    } /=`
                  )
                )
                .status(404);
              return;
            }

            if (!userExist.hasOwnProperty("customerId")) {
              //fetch user id through user email.
              const user = await shopify.customer.search({
                query: `email:${userExist.email}`,
              });
              userExist.customerId = user[0].id;

              // // // 2018-03-22T00:00:00-00:00
              // if (user.length === 0) {
              //   res
              //     .send(
              //       sendResponse(
              //         false,
              //         null,
              //         "User with this email does not exist in shopify"
              //       )
              //     )
              //     .status(404);
              //   return;
              // }
            }
            const discountName = `${userExist.discountValue}${
              userExist.discountType.toLowerCase() === "percentage" ? "%" : "$"
            }_discount_${
              new Date().toLocaleDateString() +
              "-" +
              new Date().toLocaleTimeString()
            }`;

            const price_rule = {};
            price_rule.title = discountName;
            price_rule.target_type = "line_item";
            if (userExist.discountInfo.format === "Collection") {
              price_rule.target_selection = "entitled";
              // price_rule.customer_selection = "all";
              // console.log("collections", userExist.discountInfo.collectionIds);
              price_rule.entitled_collection_ids =
                userExist.discountInfo.collectionIds;
            } else {
              price_rule.target_selection = "all";
            }
            price_rule.customer_selection = "prerequisite";

            price_rule.value_type = userExist.discountType.toLowerCase();
            price_rule.allocation_method = "across";
            price_rule.value = `-${userExist.discountValue}.0`;
            price_rule.prerequisite_customer_ids = [userExist.customerId];
            price_rule.starts_at = new Date();
            price_rule.usage_limit = 1;
            price_rule.allocation_limit = 1;
            const endDate = new Date(price_rule.starts_at);
            endDate.setMinutes(endDate.getMinutes() + 30);
            price_rule.ends_at = endDate;

            console.log("price rule id", price_rule);

            const orderDiscountPriceRule = await shopify.priceRule.create(
              price_rule
            );

            // orderDiscountPriceRule.entitled_collection_ids;

            const discountCodesUrl = `https://${employeeAssociation}/admin/api/2024-07/price_rules/${orderDiscountPriceRule.id}/discount_codes.json`;
            const discountCodeData = {
              discount_code: {
                code: discountName,
              },
            };

            const response_add_discount = await axios.post(
              discountCodesUrl,
              discountCodeData,
              {
                headers: {
                  "Content-Type": "application/json",
                  Authorization: `Basic ${Buffer.from(
                    `${decryptedApiKey}:${decryptedApiSecret}`
                  ).toString("base64")}`,
                },
              }
            );

            // console.log("Discount code created:", response_add_discount.data);
            res
              .send(
                sendResponse(
                  true,
                  response_add_discount.data,
                  "Order Discount Created Successfully"
                )
              )
              .status(200);
          } else {
            //deduct allocated discounted value from user cap remaining
            console.log("check", value, typeof value);
            const payload = {
              userCapRemain: userExist.userCapRemain - value,
            };

            await EmployeeModel.findByIdAndUpdate(userExist.id, payload, {
              new: true,
            });
            res
              .send(sendResponse(true, null, "User Cap Updated Successfully"))
              .status(200);
          }
        } else {
          res
            .send(sendResponse(false, null, "User not eligible for discount"))
            .status(400);
        }
      }
    } catch (error) {
      console.log("error", error);

      let errorMessage = "An unexpected error occurred";

      if (error.response && error.response.data && error.response.data.errors) {
        errorMessage = Object.entries(error.response.data.errors)
          .map(([key, messages]) => `${key}: ${messages}`)
          .join("\n");
      } else if (error.response?.data?.error) {
        // Shopify may return `error` instead of `errors`
        errorMessage = error.response.data.error;
      }

      res
        .status(500)
        .send(
          sendResponse(
            false,
            null,
            `Failed to create discount code. ${errorMessage}`
          )
        );
    }
  },
};

module.exports = Controller;

// BACKUP PLAN

//query shopify db to get employee details using abover emp id.
//match getted employee email with our mongo db employee email
//if emp match found get its grade and find discount % based on grades
//add that % in the payload then hit post rest api of order price rule
//hit post rest api of discount code
//return back user that discount code
