const mongoose = require("mongoose");

const organizationSchema = mongoose.Schema({
  organizationDomain: {
    type: String,
    required: true,
    unique: true,
  },
  discountValue: {
    type: String,
    required: true,
  },
  discountType: {
    type: String,
    required: true,
  },
  userCapTotal: {
    type: Number,
    required: true,
  },
  employeeAssociation: {
    type: String,
    default: null,
  },
  discountInfo: {
    format: {
      type: String,
      default: "Order",
    },
    collectionIds: {
      type: Array, // <-- now an array of strings
      default: [],
    },
  },
});

const OrganizationModel = mongoose.model("organizations", organizationSchema);

module.exports = OrganizationModel;
