const express = require("express");
const rateLimit = require("express-rate-limit");
const mongoose = require("mongoose");
const path = require("path");
const cors = require("cors");
require("dotenv").config();
const discountRoutes = require("./routes/discountRouter");
const employeeRoutes = require("./routes/employeeRouter");
const organizationRoutes = require("./routes/organizationRoute");
const app = express();
const port = process.env.PORT || 3000;

app.set("trust proxy", 1);
// Set up a rate limiter (e.g., max 100 requests per 15 minutes)
const limiter = rateLimit({
  windowMs: 15 * 60 * 1000, // 15 minutes
  max: 100, // Limit each IP to 100 requests per windowMs
  message:
    "Too many requests from this IP, please try again later after 15 minutes.",
  validate: { xForwardedForHeader: false }, // Disable validation if no proxy is used
});

// Apply the rate limiter globally
app.use(limiter);
app.use(express.json());
app.use(cors());
// Serve static files from the "storage" directory
app.use("/storage", express.static(path.join(__dirname, "storage")));

app.use("/api/organization", organizationRoutes);
app.use("/api/discount", discountRoutes);
app.use("/api/employee", employeeRoutes);

app.get("/", (req, res) => {
  res.send("Server Started for multi-store-employee-discount-app");
});

// Make sure to include this route to handle other routes
app.get("*", (req, res) => {
  res.status(404).send("Not Found");
});

mongoose
  .connect(process.env.MONGO_URI_MULTI_STORE_APP)
  .then(() => {
    app.listen(port, () => {
      console.log(
        `Database Connected Successfully and server is listening on this port ${process.env.PORT}`
      );
    });
  })
  .catch((err) => {
    console.log(err);
  });
