const express = require("express");
const jwt = require("jsonwebtoken");
const route = express.Router();
const EmployeeController = require("../Controller/employeeController");
var dotenv = require("dotenv");
dotenv.config();
const authMiddleware = require("../Helper/middleware");
const sendResponse = require("../Helper/Helper");
const StoreSchema = require("../models/StoreSchema");
const Hash = require("../Helper/hashing");
// Middleware to validate Shopify Session Token
const validateSessionToken = async (req, res, next) => {
  let employeeAssociation =
    req.query?.employeeAssociation || req.body?.employeeAssociation; // Use query or body
  const token = req.headers.authorization?.split(" ")[1];

  if (!employeeAssociation) {
    return res
      .send(
        sendResponse(
          false,
          null,
          `Employee store name is not present in query or body of the request.".`
        )
      )
      .status(401);
  }
  if (!token) {
    return res
      .send(sendResponse(false, null, `Session token missing".`))
      .status(401);
  }
  const store = await StoreSchema.findOne({
    shopName: employeeAssociation,
  });

  if (!store) {
    return res
      .send(sendResponse(false, null, `No credentials found for the shop.`))
      .status(404);
  }

  const decryptedApiKey = await Hash.decrypt(store.apiKey);
  const sessionToken = await Hash.decrypt(store.apiSessionToken);
  try {
    const decoded = jwt.verify(token, sessionToken);
    req.shop = decoded.dest.replace("https://", "").split("/")[0]; // Extract shop domain
    next();
  } catch (error) {
    console.error("Invalid session token:", error);
    // res.status(401).json({ message: "Invalid session token" });
    res.send(sendResponse(false, null, `Invalid session token`)).status(401);
  }
};
// route.use(authMiddleware);
route.get("/", validateSessionToken, EmployeeController.getEmployees);
route.get("/:id", EmployeeController.getSingleEmployees);
route.get("/org/:orgId", EmployeeController.getSingleOrganizationEmployees);
route.post("/", (req, res) => EmployeeController.addEmployee(req, res, false));
route.patch("/:id", EmployeeController.editEmployee);
route.delete("/:id", EmployeeController.deleteEmployee);

module.exports = route;
