const express = require("express");
const CourseModel = require("../models/DiscountModel");
const sendResponse = require("../Helper/Helper");
const Controller = require("../Controller/discountController");
const jwt = require("jsonwebtoken");
const StoreSchema = require("../models/StoreSchema");
const Hash = require("../Helper/hashing");
const route = express.Router();

// Middleware to validate Shopify Session Token
const validateSessionToken = async (req, res, next) => {
  const { employeeAssociation } = req.body;
  const token = req.headers.authorization?.split(" ")[1];
  if (!token) {
    return res
      .send(sendResponse(false, null, `Session token missing".`))
      .status(401);
  }
  const store = await StoreSchema.findOne({
    shopName: employeeAssociation,
  });

  if (!store) {
    return res
      .send(sendResponse(false, null, `No credentials found for the shop.`))
      .status(404);
  }

  const decryptedApiKey = await Hash.decrypt(store.apiKey);
  const sessionToken = await Hash.decrypt(store.apiSessionToken);
  try {
    const decoded = jwt.verify(token, sessionToken);
    req.shop = decoded.dest.replace("https://", "").split("/")[0]; // Extract shop domain
    next();
  } catch (error) {
    console.error("Invalid session token:", error);
    // res.status(401).json({ message: "Invalid session token" });
    res.send(sendResponse(false, null, `Invalid session token`)).status(401);
  }
};

route.post("/", Controller.AddOrderDiscount);

module.exports = route;
