const sendResponse = require("../Helper/Helper");
const OrganizationModel = require("../models/OrganizationModel");
const checkEmailValidity = require("../Helper/checkEmail");
var dotenv = require("dotenv");
const Hash = require("../Helper/hashing");
const Shopify = require("shopify-api-node");
const StoreSchema = require("../models/StoreSchema");
dotenv.config();

const OrganizationController = {
  getOrganizations: async (req, res) => {
    try {
      let { page, limit, employeeAssociation } = req.query;

      if (!page) page = 1;
      if (!limit) limit = 50;

      const skip = (page - 1) * limit;

      if (!employeeAssociation) {
        res
          .send(sendResponse(false, null, "Required employee shop domain"))
          .status(400);
        return;
      }
      const result = await OrganizationModel.find({
        employeeAssociation,
      })
        .skip(skip)
        .limit(limit);
      // .aggregate([
      //   {
      //     $lookup: {
      //       from: "employees_global",
      //       localField: "_id",
      //       foreignField: "employeeOrganization",
      //       as: "employees",
      //     },
      //   },
      // ]);

      if (!result) {
        res
          .send(sendResponse(false, null, "No Organization Data Found"))
          .status(404);
      } else {
        res
          .send(sendResponse(true, result, "Organization Data Found"))
          .status(200);
      }
    } catch (error) {
      console.log(error);
      res
        .send(sendResponse(false, null, "Server Internal Error", error))
        .status(400);
    }
  },
  addOrganization: async (req, res) => {
    let {
      domain,
      userCapTotal,
      discountType,
      discountValue,
      discountFormat,
      CollectionId,
      employeeAssociation,
    } = req.body;
    try {
      let errArr = [];

      //validation part
      if (!domain) {
        errArr.push("Required employee domain");
      }
      if (discountFormat && !CollectionId) {
        errArr.push("Required Collection Id");
      }

      if (!userCapTotal) {
        errArr.push("Required employee Total Cap");
      }
      if (!discountValue) {
        errArr.push("Required employee discount Value");
      }
      if (!discountType) {
        errArr.push("Required discount type");
      }
      if (!employeeAssociation) {
        errArr.push("Required employee Association");
      }

      if (errArr.length > 0) {
        res
          .send(sendResponse(false, errArr, null, "Required All Fields"))
          .status(400);
        return;
      } else {
        let userExist = await OrganizationModel.findOne({
          organizationDomain: domain.replace(/[^a-zA-Z0-9]/g, ""),
        });

        if (userExist) {
          // console.log(userExist, "user");
          res
            .send(
              sendResponse(
                false,
                null,
                "Organization with this domain already exist"
              )
            )
            .status(400);
          return;
        } else {
          //add new user to mongodb
          let obj = {
            organizationDomain: domain.replace(/[^a-zA-Z0-9]/g, ""),
            userCapTotal,
            discountType,
            discountValue,
            employeeAssociation,
          };
          obj = {
            ...obj,
            userCapRemain: userCapTotal,
            ...(discountFormat && {
              discountInfo: {
                format: discountFormat,
                // Only add collectionIds if the format is "Collection"
                ...(discountFormat === "Collection" && {
                  collectionIds: CollectionId.map((item) => parseInt(item)), // Only include if format is "Collection"
                }),
              },
            }),
          };

          // console.log("object", obj);
          let Organization = new OrganizationModel(obj);
          await Organization.save();

          res
            .send(sendResponse(true, null, "Organization Added Successfully"))
            .status(200);
        }
      }
    } catch (error) {
      console.log("error reason", error.stack);
      let errorMessage = "An unexpected error occurred";
      if (error.response && error.response.data && error.response.data.errors) {
        // Extract and format dynamic errors
        errorMessage = Object.entries(error.response.data.errors)
          .map(([key, messages]) => `${key}: ${messages}`)
          .join("\n");
      }
      res
        .send(sendResponse(false, null, errorMessage, "Internal Server Error"))
        .status(400);
    }
  },
  editOrganization: async (req, res) => {
    try {
      let {
        userCapTotal,
        employeeAssociation,
        discountType,
        discountValue,
        discountFormat,
        CollectionId,
      } = req.body;
      let id = req.params.id;
      if (!id) {
        return res.send(sendResponse(false, null, "id not found")).status(404);
      }
      let result = await OrganizationModel.findById(id);
      if (!result) {
        res
          .send(sendResponse(false, null, "Employee with specified id Found"))
          .status(404);
      } else {
        let obj = {
          userCapTotal,
          employeeAssociation,
          discountType,
          discountValue,
        };
        obj = {
          ...obj,
          userCapRemain: userCapTotal,
          ...(discountFormat && {
            discountInfo: {
              format: discountFormat,
              // Only add collectionIds if the format is "Collection"
              ...(discountFormat === "Collection" && {
                collectionIds: CollectionId.map((item) => parseInt(item)), // Only include if format is "Collection"
              }),
            },
          }),
        };

        let updateResult = await OrganizationModel.findByIdAndUpdate(id, obj, {
          new: true,
        });
        if (!updateResult) {
          res
            .send(sendResponse(false, null, "Unable to update organization"))
            .status(404);
        } else {
          res
            .send(
              sendResponse(
                true,
                updateResult,
                "Organization data updated SuccessFully"
              )
            )
            .status(200);
        }
      }
    } catch (e) {
      res
        .send(sendResponse(false, null, e, "Internal Server Error"))
        .status(400);
    }
  },
  deleteEmployee: async (req, res) => {
    try {
      let id = req.params.id;
      if (!id) {
        return res.send(sendResponse(false, null, "id not found")).status(404);
      }
      let result = await OrganizationModel.findById(id);
      // // console.log("resultant", result);
      // if (!id) {
      //   return res.send(sendResponse(false, null, "employee with specified id not found")).status(404);
      // }
      if (!result) {
        res
          .send(sendResponse(false, null, "Employee with specified id Found"))
          .status(404);
      } else {
        let deleteById = await OrganizationModel.findByIdAndDelete(id);
        if (!deleteById) {
          res.send(sendResponse(false, null, "Error")).status(404);
        } else {
          res
            .send(
              sendResponse(
                true,
                deleteById,
                "Employee Data Deleted Successfully"
              )
            )
            .status(200);
        }
      }
    } catch (e) {
      res
        .send(sendResponse(false, null, e, "Internal Server Error"))
        .status(400);
    }
  },
  getSingleOrganization: async (req, res) => {
    let domain = req.params.domain;
    if (!domain) {
      return res
        .send(
          sendResponse(false, null, "domain not given,please input domain.")
        )
        .status(404);
    }
    await OrganizationModel.findOne({ organizationDomain: domain })
      .then((result) => {
        res
          .send(
            sendResponse(
              true,
              result,
              "Organization Exist In our DB. proceed to create employee with given payload."
            )
          )
          .status(200);
      })
      .catch((err) => {
        console.log(err);
        res
          .send(sendResponse(false, err, "Organization not found"))
          .status(404);
      });
  },
  deleteOrganization: async (req, res) => {
    try {
      let id = req.params.id;
      if (!id) {
        return res.send(sendResponse(false, null, "id not found")).status(404);
      }
      let result = await OrganizationModel.findById(id);
      // // console.log("resultant", result);
      // if (!id) {
      //   return res.send(sendResponse(false, null, "employee with specified id not found")).status(404);
      // }
      if (!result) {
        res
          .send(
            sendResponse(false, null, "Organization with specified id Found")
          )
          .status(404);
      } else {
        let deleteById = await OrganizationModel.findByIdAndDelete(id);
        if (!deleteById) {
          res.send(sendResponse(false, null, "Error")).status(404);
        } else {
          res
            .send(
              sendResponse(
                true,
                deleteById,
                "Organization Data Deleted SucessFully"
              )
            )
            .status(200);
        }
      }
    } catch (e) {
      res
        .send(sendResponse(false, null, e, "Internal Server Error"))
        .status(400);
    }
  },
};

module.exports = OrganizationController;
